/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLib;
import tech.thatgravyboat.duckling.common.entity.DuckEggEntity;
import tech.thatgravyboat.duckling.common.entity.DuckEntity;
import tech.thatgravyboat.duckling.common.entity.QuacklingEntity;
import tech.thatgravyboat.duckling.common.registry.ModEntities;
import tech.thatgravyboat.duckling.common.registry.ModItems;
import tech.thatgravyboat.duckling.common.registry.ModSounds;

public class Duckling {
    public static final String MODID = "duckling";
    private static final ResourceKey<CreativeModeTab> FOOD = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("food_and_drinks"));
    private static final ResourceKey<CreativeModeTab> SPAWN_EGGS = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("spawn_eggs"));
    private static final ResourceKey<CreativeModeTab> INGREDIENTS = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("ingredients"));

    public static void init() {
        GeckoLib.initialize();
        ModItems.register();
        ModEntities.register();
        ModSounds.register();
    }

    public static void lateInit() {
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.DUCK_EGG.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            @NotNull
            protected Projectile m_6895_(@NotNull Level level, @NotNull Position pos, @NotNull ItemStack stack) {
                return (Projectile)Util.m_137469_((Object)((Object)new DuckEggEntity(level, pos.m_7096_(), pos.m_7098_(), pos.m_7094_())), egg -> egg.m_37446_(stack));
            }
        });
    }

    public static void addEntityAttributes(Map<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> attributes) {
        attributes.put(ModEntities.DUCK.get(), DuckEntity.createDuckAttributes());
        attributes.put(ModEntities.QUACKLING.get(), QuacklingEntity.createQuacklingAttributes());
    }

    public static void addCreativeTabContent(ResourceKey<CreativeModeTab> tab, Consumer<Item> consumer) {
        if (tab == FOOD) {
            consumer.accept(ModItems.HOLIDAY_FRUIT_CAKE.get());
            consumer.accept(ModItems.RAW_DUCK.get());
            consumer.accept(ModItems.COOKED_DUCK.get());
        }
        if (tab == SPAWN_EGGS) {
            consumer.accept((Item)ModItems.DUCK_SPAWN_EGG.get());
            consumer.accept((Item)ModItems.QUACKLING_SPAWN_EGG.get());
        }
        if (tab == INGREDIENTS) {
            consumer.accept(ModItems.DUCK_EGG.get());
        }
    }

    public static ResourceLocation modId(String path) {
        return new ResourceLocation(MODID, path);
    }
}

